ORCA/M Asm65816 2.1.0

0001 04E7                       eject 
0002 04E7              *****************************************************************
0003 04E7              *
0004 04E7              * DRIVER MAIN entry POINT: DISPATCH
0005 04E7              *
0006 04E7              * This is the main entry point for the device driver.  The
0007 04E7              * routine validates the call number prior to dispatching to
0008 04E7              * the requested function.
0009 04E7              *
0010 04E7              * Call Number:  $0000   Function: Startup
0011 04E7              *               $0001             Open
0012 04E7              *               $0002             Read
0013 04E7              *               $0003             Write
0014 04E7              *               $0004             Close
0015 04E7              *               $0005             Status
0016 04E7              *               $0006             Control
0017 04E7              *               $0007             Flush
0018 04E7              *               $0008             Shutdown
0019 04E7              *               $0009-$FFFF       Reserved
0020 04E7              *
0021 04E7              * ENTRY: Call via 'JSL'
0022 04E7              *     [<drvr_dib_ptr] = Points to the DIB for the device being accessed
0023 04E7              *       <drvr_dev_num = Device number of device being accessed
0024 04E7              *      <drvr_call_num = Call number
0025 04E7              *               A Reg = Call Number
0026 04E7              *               X Reg = Undefined
0027 04E7              *               Y Reg = Undefined
0028 04E7              *             Dir Reg = GS/OS Direct Page
0029 04E7              *               B Reg = Undefined
0030 04E7              *               P Reg = N V M X D I Z C  E
0031 04E7              *                       x x 0 0 0 0 x x  0
0032 04E7              *
0033 04E7              * EXIT:   Direct page = unchanged with the exception of <drvr_tran_cnt
0034 04E7              *               A Reg = Error code
0035 04E7              *               X Reg = Undefined
0036 04E7              *               Y Reg = Undefined
0037 04E7              *             Dir Reg = GS/OS Direct Page
0038 04E7              *               B Reg = Same as entry
0039 04E7              *               P Reg = N V M X D I Z C  E
0040 04E7              *                       x x 0 0 0 0 x 0  0   No error occured
0041 04E7              *                       x x 0 0 0 0 x 1  0   Error occured
0042 04E7              *
0043 04E7              *****************************************************************
0044 04E7                       export dispatch
0045 04E7              dispatch proc 
0046 04E7                                                      ;using   driver_data
0047 04E7                       longa on
0048 04E7                       longi on
0049 04E7
0050 04E7 8B                    phb                            ; save environment
0051 04E8 4B                    phk   
0052 04E9 AB                    plb   
0053 04EA C9 09 00              cmp   #max_command             ; is it a legal command?
0054 04ED B0 72                 bge   illegal_req              ; no
0055 04EF A2 00 00              ldx   #$0000
0056 04F2              save_parms                              ;
0057 04F2 B5 00                 lda   <drvr_dev_num,x          ; save GS/OS call parameters
0058 04F4 48                    pha   
0059 04F5 B5 10                 lda   <drvr_blk_num,x
0060 04F7 48                    pha   
0061 04F8 E8                    inx   
0062 04F9 E8                    inx   
0063 04FA E0 0C 00              cpx   #$000C                   ; up to but not including DRVR_TRAN_CNT
0064 04FD D0 F3                 bne   save_parms
0065 04FF
0066 04FF A5 02                 lda   <drvr_call_num           ; is this a startup call?
0067 0501 F0 1C                 beq   continue                 ; yes
0068 0503
0069 0503 A0 2E 00              ldy   #slot_num                ;set the int_slot flag
0070 0506 B7 20                 lda   [<drvr_dib_ptr],y
0071 0508 29 08 00              and   #%1000                   ; 
0072 050B F0 03                 beq   @10                      ; 0 for internal slot 5
0073 050D A9 FF FF              lda   #-1                      ;-1 for external slot N
0074 0510 8D 68 03     @10      sta   ext_slot                 ;record if this call's slot is external
0075 0513
0076 0513 20 67 05              jsr   check_access             ; did external access occur?
0077 0516 90 07                 bcc   continue                 ; no
0078 0518 22 90 FC 01           jsl   set_disksw               ; mark the VCRs and flush cache
0079 051C 20 01 08              jsr   set_hook                 ; reinstall our patches
0080 051F
0081 051F              continue                                ; 
0082 051F A5 02                 lda   <drvr_call_num           ; restore command #
0083 0521 F4 2A 05              pea   func_ret-1               ; return address from function
0084 0524 0A                    asl   a                        ; make index to dispatch table
0085 0525 AA                    tax   
0086 0526 BD 30 03              lda   |dispatch_table,x
0087 0529 48                    pha                            ; push function address for dispatch
0088 052A 60                    rts                            ; rts dispatches to function
0089 052B              *
0090 052B              * Must clear the access flag on the way out so that any direct
0091 052B              * access to an AppleDisk3.5 drive can be detected.
0092 052B              *
0093 052B              func_ret                                ;
0094 052B 08                    php   
0095 052C 48                    pha                            ; save error code
0096 052D 90 13                 bcc   @80                      ;no error
0097 052F C9 2E 01              cmp   #drvr_disk_sw+$100       ;returning with pseudo disk_sw from Fixup?
0098 0532 D0 06                 bne   @10
0099 0534 68                    pla   
0100 0535 F4 2E 00              pea   #drvr_disk_sw            ;convert pseudo to read dsw
0101 0538 80 08                 bra   @80
0102 053A C9 2E 00     @10      cmp   #drvr_disk_sw            ;is this a REAL disk switched ERROR ?
0103 053D D0 03                 bne   @80                      ;no.
0104 053F              * when firmware gives a disk_sw then go try to get blk count
0105 053F 20 6A 0B              jsr   Fixup_blkcnt             ;go try to get a new blockcount in DIB
0106 0542
0107 0542 A0 4C 00     @80      ldy   #dib_acc_flag
0108 0545 A9 00 00              lda   #00
0109 0548 97 20                 sta   [<drvr_dib_ptr],y        ;clear the access flag
0110 054A 7A                    ply                            ; this is the error code
0111 054B 28                    plp   
0112 054C
0113 054C A2 0A 00              ldx   #$000A                   ; number of words to restore
0114 054F              restore_parms  
0115 054F 68                    pla                            ; restore GS/OS call parameters
0116 0550 95 10                 sta   <drvr_blk_num,x
0117 0552 68                    pla   
0118 0553 95 00                 sta   <drvr_dev_num,x
0119 0555 CA                    dex   
0120 0556 CA                    dex   
0121 0557 10 F6                 bpl   restore_parms
0122 0559 AB                    plb   
0123 055A B0 03                 bcs   gen_exit                 ; force error code 0 if flag cleared
0124 055C A0 00 00              ldy   #no_error
0125 055F              gen_exit                                ;
0126 055F 98                    tya                            ; restore error code
0127 0560 6B                    rtl   
0128 0561              *
0129 0561              * Received an illegal request.  Return with an error.
0130 0561              *
0131 0561              illegal_req                             ; 
0132 0561 AB                    plb                            ; restore environement
0133 0562 A9 20 00              lda   #drvr_bad_req            ; set error
0134 0565 38                    sec   
0135 0566 6B                    rtl   
0136 0567
0137 0567                       eject 
0138 0567              *****************************************************************
0139 0567              *
0140 0567              * CHECK_ACCESS
0141 0567              *
0142 0567              * This routine is called by various driver functions to determine
0143 0567              * if an invalid external access has occured.
0144 0567              *
0145 0567              * ENTRY: Call via 'JSR'
0146 0567              *               A Reg = Undefined
0147 0567              *               X Reg = Undefined
0148 0567              *               Y Reg = Undefined
0149 0567              *             Dir Reg = GS/OS Direct Page
0150 0567              *               B Reg = Undefined
0151 0567              *               P Reg = N V M X D I Z C  E
0152 0567              *                       x x 0 0 0 0 x x  0
0153 0567              *
0154 0567              * EXIT: via an 'RTS'
0155 0567              *               A Reg = Error code
0156 0567              *               X Reg = Undefined
0157 0567              *               Y Reg = Undefined
0158 0567              *             Dir Reg = GS/OS Direct Page
0159 0567              *               B Reg = Same as entry
0160 0567              *               P Reg = N V M X D I Z C  E
0161 0567              *                       x x 0 0 0 0 x 0  0   No error occured
0162 0567              *                       x x 0 0 0 0 x 1  0   Error occured
0163 0567              *
0164 0567              *****************************************************************
0165 0567                       export check_access
0166 0567              check_access                            ;
0167 0567                       longa on
0168 0567                       longi on
0169 0567 5A                    phy   
0170 0568 18                    clc   
0171 0569 A0 4C 00              ldy   #dib_acc_flag            ; determine if this unit was accessed
0172 056C B7 20                 lda   [<drvr_dib_ptr],y
0173 056E F0 04                 beq   check_done               ; if no direct access ocurred
0174 0570
0175 0570 A9 2E 01              lda   #drvr_disk_sw+$100       ; then return a disk switch error
0176 0573 38                    sec   
0177 0574 7A           check_done ply   
0178 0575 60                    rts   
0179 0576                       endp 
0180 0576                       eject 
0181 0576              *****************************************************************
0182 0576              *
0183 0576              * DRIVER CALL:  STARTUP
0184 0576              *
0185 0576              * This routine must prepare the driver to accept all other driver
0186 0576              * calls.
0187 0576              *
0188 0576              * ENTRY: Call via 'JSR'
0189 0576              *     [<drvr_dib_ptr] = Points to the DIB for the device being accessed
0190 0576              *       <drvr_dev_num = Device number of device being accessed
0191 0576              *      <drvr_call_num = Call number
0192 0576              *      <drvr_tran_cnt = $00000000
0193 0576              *               A Reg = Call Number
0194 0576              *               X Reg = Undefined
0195 0576              *               Y Reg = Undefined
0196 0576              *             Dir Reg = GS/OS Direct Page
0197 0576              *               B Reg = Same as program bank
0198 0576              *               P Reg = N V M X D I Z C  E
0199 0576              *                       x x 0 0 0 0 x x  0
0200 0576              *
0201 0576              * EXIT: via an 'RTS'
0202 0576              *               A Reg = Error code
0203 0576              *               X Reg = Undefined
0204 0576              *               Y Reg = Undefined
0205 0576              *             Dir Reg = GS/OS Direct Page
0206 0576              *               B Reg = Same as entry
0207 0576              *               P Reg = N V M X D I Z C  E
0208 0576              *                       x x 0 0 0 0 x 0  0   No error occured
0209 0576              *                       x x 0 0 0 0 x 1  0   Error occured
0210 0576              *
0211 0576              *****************************************************************
0212 0576                       longa on
0213 0576                       longi on
0214 0576
0215 0576                       export startup
0216 0576              startup  proc 
0217 0576 08                    php   
0218 0577              *
0219 0577              * Check ROM version number.
0220 0577 A9 00 00              lda   #$0000
0221 057A 48                    pha                            ; space for result
0222 057B 48                    pha   
0223 057C 48                    pha   
0224 057D 48                    pha   
0225 057E 48                    pha                            ; A Reg on call
0226 057F 48                    pha                            ; X Reg on call
0227 0580 48                    pha                            ; Y Reg on call
0228 0581 F4 1F FE              pea   $FE1F                    ; call monitor id routine
0229 0584 A2 03 24 22           _fwentry 
0230 058B 7A                    ply   
0231 058C FA                    plx   
0232 058D 68                    pla   
0233 058E 68                    pla   
0234 058F 28                    plp   
0235 0590 8C 66 03              sty   |rom_version             ; save version for conditional patches
0236 0593              *****
0237 0593
0238 0593 AD 62 03              lda   last_drive
0239 0596 AD 5E 03              lda   slot_count
0240 0599 AD 60 03              lda   last_slot                ;last_slot must be zeroed by ShutDown!
0241 059C F0 05                 beq   @1stTime
0242 059E 10 1B                 bpl   @scanSlots
0243 05A0 82 62 00              brl   no_drive_exit            ;negative last_slot mean I tried em all
0244 05A3 A9 05 00     @1stTime lda   #05                      ;start with Internal slot 5
0245 05A6 8D 60 03              sta   last_slot
0246 05A9 9C 62 03              stz   last_drive
0247 05AC 9C 5A 03              stz   device_count
0248 05AF 9C 5E 03              stz   slot_count
0249 05B2 A9 41 20              lda   #' A'
0250 05B5 8D 64 03              sta   name_char                ;start device names at ...A
0251 05B8              *
0252 05B8              *  copy the code to bank 1 on the assumption Internal S5 in use
0253 05B8 20 9F 07              jsr   copy_to_bank1
0254 05BB              @scanSlots  
0255 05BB              *
0256 05BB              * setup Y with contents of slots reg
0257 05BB E2 20                 sep   #$20                     ; 8 bit 'm'
0258 05BD                       longa off
0259 05BD AF 2D C0 00           lda   >sltromsel               ; need slot internal/external
0260 05C1 8D BB 03              sta   SlotsReg
0261 05C4 C2 20                 rep   #$20                     ; 16 bit 'm'
0262 05C6                       longa on
0263 05C6
0264 05C6 EE 62 03              inc   last_drive               ;= 1,2,3
0265 05C9 AD 62 03              lda   last_drive
0266 05CC C9 02 00              cmp   #0002                    ;is this 1st drive for a slot?
0267 05CF 90 0B                 bcc   @chkSlot                 ;< must be a 1
0268 05D1 F0 76                 beq   do_2nd_drive             ;already checkd the slot 
0269 05D3 A9 01 00              lda   #0001
0270 05D6 8D 62 03              sta   last_drive               ;back to drive 1 for next slot
0271 05D9 20 7B 07              jsr   nextSlot                 ;move last_slot to next candidate
0272 05DC              *
0273 05DC              * now check the for internal vs external tests
0274 05DC AD 60 03     @chkSlot lda   last_slot
0275 05DF 89 08 00              bit   #%1000
0276 05E2 D0 17                 bne   check_extslots
0277 05E4              *
0278 05E4              * now check for Slot 5 set to internal! (since slot 5 is the only internal one)
0279 05E4 AD BB 03              lda   SlotsReg                 ; bug fix 09/24/91 JOA
0280 05E7 29 20 00              and   #$0020                   ; is slot 5 set for external?
0281 05EA D0 09                 bne   @do_S5_ext               ; yes!. so go see if its a SmartPort card
0282 05EC              *
0283 05EC              * The following 3 lines were added in version 4.1a02. (locks out ROM 0, I think)
0284 05EC AF FB C5 00           lda   >$00C5FB                 ; is extended supported by this ROM?
0285 05F0 29 80 00              and   #$0080
0286 05F3 D0 1D                 bne   do_a_Slot                ; require GS ROM with Extended SmartPort Firmware
0287 05F5
0288 05F5 A9 0D 00     @do_S5_ext lda   #0005+8                ;switch to slot 5 external
0289 05F8 8D 60 03              sta   last_slot
0290 05FB 20 09 07     check_extslots jsr   is_XSP_slot        ;is this a slot with Extended & Addnl SmartPort
0291 05FE F0 12                 beq   do_a_slot                ;yep.
0292 0600
0293 0600 20 7B 07     next_Slot jsr   nextslot                ;move last_slot to the next possible one
0294 0603 10 F6                 bpl   check_extslots           ;more slots to check
0295 0605
0296 0605 A9 28 00     no_drive_exit lda   #drvr_no_dev        ;assume I found at least 1 slot to use
0297 0608 AE 5E 03              ldx   slot_count               ;did I find anything?
0298 060B D0 03                 bne   @exit                    ;yep
0299 060D              *
0300 060D              * Either this is ROM 00 or this system has zero 3.5 drives
0301 060D A9 27 00              lda   #drvr_io_error           ;cause the entire Driver to be removed!
0302 0610 38           @exit    sec   
0303 0611 60                    rts   
0304 0612              *
0305 0612              * Need to determine if any AppleDisk3.5 devices are connected to
0306 0612              * the slot's controller.  Get number of devices and walk its chain.
0307 0612 9C 5C 03     do_a_slot stz   slot_units              ;assmue no units attached to controller card
0308 0615 9C D2 03              stz   unit0_slist              ;zero the slot's unit count
0309 0618 9C D4 03              stz   unit0_slist+2            ;zero the vendor ID too
0310 061B E2 20                 sep   #$20                     ; 8-bit m
0311 061D                       longa off
0312 061D 9C E0 03              stz   dib_unit                 ;zero dib_unit.b
0313 0620 C2 20                 rep   #$20                     ; 16-bit m
0314 0622                       longa on
0315 0622 20 57 07              jsr   Fillin_dib               ;fillin the dib stuff for Unit0 Status call
0316 0625
0317 0625              *
0318 0625              * Get device count by making Unit Zero status call
0319 0625 A5 00                 lda   <drvr_dev_num
0320 0627 A2 C6 03              ldx   #unit0_stat
0321 062A 22 80 FC 01           jsl   to_b0_core               ;returns error code in A
0322 062E 90 01                 bcc   @10
0323 0630 60                    rts   
0324 0631 AD D2 03     @10      lda   |unit0_slist             ; any devices in this slot?
0325 0634 29 7F 00              and   #$007F                   ;(16-bit fetch above of 8 bit item)
0326 0637 F0 C7                 beq   next_slot                ; no. see if any other slots have SP firmware
0327 0639 8D 5C 03              sta   slot_units
0328 063C EE 5E 03              inc   slot_count               ; cnt number of slots with SmartPort
0329 063F AD 5E 03              lda   slot_count
0330 0642 C9 05 00              cmp   #05                      ;have I found 4 slots of SmartPorts?
0331 0645 B0 BE                 bcs   no_drive_exit            ;how'd I get more than 8 dib startup calls?!??
0332 0647 80 03                 bra   do_a_drive
0333 0649 20 57 07     do_2nd_drive jsr   Fillin_dib           ;fillin the dib stuff for Smartport calls
0334 064C              *
0335 064C              * Devices are connected to the SmartPort device chain.  Find the
0336 064C              * first 3.5 drive starting with the next unit number and continue
0337 064C              * unitl the end of the chain if neccessary.
0338 064C              do_a_drive:  
0339 064C EE E0 03              inc   dib_unit                 ; next SmartPort Unit to check (16-bit INC of 8 bit item!!)
0340 064F AD E0 03              lda   dib_unit                 ; is unit # valid? (16-bit fetch of 8 bit item!)
0341 0652 29 7F 00              and   #$007F                   ; drop the extra byte
0342 0655 CD 5C 03              cmp   slot_units               ;have I scanned all the units yet?
0343 0658 90 0F                 bcc   call_ok                  ; no.
0344 065A F0 0D                 beq   call_ok                  ; no.
0345 065C AD 62 03              lda   last_drive               ; yes. 
0346 065F C9 01 00              cmp   #0001                    ;still looking for 1st drive in this slot?
0347 0662 D0 A1                 bne   no_drive_exit            ; 1st unit (drive) found for previous dib startup
0348 0664 CE 5E 03              dec   slot_count               ; un count this slot since no AD35 drives found
0349 0667 80 97                 bra   next_Slot                ; this slot doesn't have any AD3.5 drives!
0350 0669              *
0351 0669              call_ok   
0352 0669 A5 00                 lda   <drvr_dev_num            ; make dib status call to see if 
0353 066B A2 DA 03              ldx   #dib_stat                ; this unit is an AD3.5 or SuperDrive
0354 066E 9C FC 03              stz   sp_type                  ; trash previous device type result
0355 0671 22 80 FC 01           jsl   to_b0_core
0356 0675 B0 D5                 bcs   do_a_drive               ; check next unit if error
0357 0677 AD FC 03              lda   sp_type                  ; is type/subtype appledisk3.5
0358 067A 29 FF FE              and   #$FEFF                   ; ignore additional cmds bit of SuperDrive
0359 067D C9 01 C0              cmp   #$C001
0360 0680 D0 CA                 bne   do_a_drive               ; if not AD3.5 or FDHD then check next unit
0361 0682
0362 0682 AD FD 03              lda   sp_type+1
0363 0685 4A                    lsr   a                        ;C = 1 if FDHD
0364 0686 A9 03 00              lda   #0003                    ;assume AppleDisk3.5 drive
0365 0689 90 03                 bcc   @10
0366 068B A9 17 00              lda   #$0017                   ;FDHD ID number
0367 068E A0 34 00     @10      ldy   #dev_id_num
0368 0691 97 20                 sta   [drvr_dib_ptr],y         ;mark the dib with proper Device ID number
0369 0693 AD E6 03              lda   dib_slist                ;get general status byte (16-bit fetch of 8 bit item)
0370 0696 29 17 00              and   #%10111                  ;save all the status bits
0371 0699 A0 50 00              ldy   #dib_last_sts
0372 069C 97 20                 sta   [drvr_dib_ptr],y         ; initialize last-sts in DIB
0373 069E C9 10 00              cmp   #$0010                   ;c = 1 if Online media so block count is real
0374 06A1 AD E7 03              lda   dib_blkcnt
0375 06A4 B0 03                 bcs   @11
0376 06A6 A9 00 00              lda   #0000                    ;zero blocks if Offline
0377 06A9 A0 0A 00     @11      ldy   #blk_cnt
0378 06AC 97 20                 sta   [drvr_dib_ptr],y         ;init the blockcount in dib
0379 06AE AD E9 03              lda   dib_blkcnt+2
0380 06B1 B0 03                 bcs   @12
0381 06B3 A9 00 00              lda   #0000                    ;zero blocks if Offline
0382 06B6 C8           @12      iny   
0383 06B7 C8                    iny   
0384 06B8 97 20                 sta   [drvr_dib_ptr],y         ;init the blockcount in dib
0385 06BA 20 6F 07     @blksNotknown jsr   Fillin_Unit         ;put SmartPort unit# into my DIB
0386 06BD
0387 06BD AD 60 03              lda   last_slot
0388 06C0 29 08 00              and   #%1000                   ;internal slot?
0389 06C3 F0 03                 beq   @20                      ;no. so make flag zero
0390 06C5 A9 FF FF              lda   #-1                      ;-1 = External Mustang card
0391 06C8 8D 68 03     @20      sta   ext_slot                 ;set slot type for set_hook and set_extaccess
0392 06CB
0393 06CB 20 54 08              jsr   set_extaccess            ;download external access detector code
0394 06CE B0 38                 bcs   @err
0395 06D0
0396 06D0 AD 62 03              lda   last_drive
0397 06D3 C9 01 00              cmp   #0001                    ;1st drive for this slot ?
0398 06D6 18                    clc                            ;clear carry for dispatch
0399 06D7 D0 0B                 bne   @30
0400 06D9              *
0401 06D9              * The rom version requires the driver and slot 5 is set internal.
0402 06D9              * and this is the first drive  SOOO
0403 06D9              * Let's install the MERGIT patch before passing control to the
0404 06D9              * generated driver core routines in order to finish the startup
0405 06D9              * sequence which includes setting the default interleave to 2:1.
0406 06D9 20 01 08              jsr   set_hook                 ;only need to do this once per slot (after unit 1)
0407 06DC B0 06                 bcs   @30                      ;might get an error! 
0408 06DE              *
0409 06DE              * Now set default options and interleave to 2:1.
0410 06DE A9 00 00              lda   #0000                    ;internal call to set "defaults"
0411 06E1 20 C9 0B              jsr   set_option               ;just in case last fmt was 400K or something stupid
0412 06E4
0413 06E4 B0 22        @30      bcs   @err
0414 06E6
0415 06E6 EE 5A 03              inc   device_count             ; cnt number of appledisk3.5's online
0416 06E9              *** added 3-Jun-92 DAL -- Don't rebuild device names on a warm start
0417 06E9 AF D0 01 E1           lda   >warm_cold_flag          ;nonzero = warm startup
0418 06ED D0 15                 bne   @noBuildName
0419 06EF              *** end 3-Jun-92
0420 06EF A0 0E 00              ldy   #dev_name
0421 06F2 B7 20                 lda   [drvr_dib_ptr],y         ;
0422 06F4 29 3F 00              and   #$003F
0423 06F7 18                    clc   
0424 06F8 69 0E 00              adc   #dev_name
0425 06FB A8                    tay   
0426 06FC AD 64 03              lda   name_char
0427 06FF 97 20                 sta   [drvr_dib_ptr],y
0428 0701 EE 64 03              inc   name_char                ;count to next letter for next device 
0429 0704 A9 00 00     @noBuildName lda   #no_error
0430 0707 18                    clc   
0431 0708 60           @err     rts   
0432 0709
0433 0709              **********************************************************************
0434 0709              *       Is_XSP_slot:
0435 0709              *
0436 0709              *       Entry:  m = 1, x = 1
0437 0709              *               y = sltromsel register
0438 0709              *
0439 0709              *       Exit:   m = 1, x= 1
0440 0709              *               EQ if it is
0441 0709              *               NE if it aint (either slot is internal or no SP firmware
0442 0709              *
0443 0709              *  Preserves:   Y       Uses A,X
0444 0709              *
0445 0709              **********************************************************************
0446 0709                       longa on
0447 0709                       longi on
0448 0709 AD 60 03     Is_XSP_slot: lda   last_slot
0449 070C 29 07 00              and   #0007
0450 070F 0A                    asl   a                        ;slot * 2
0451 0710 AA                    tax   
0452 0711 AD BB 03              lda   SlotsReg
0453 0714 3D 47 07              and   slotreg_bit-2,x          ;is this slot set to external?
0454 0717 F0 2E                 beq   @notxSlot                ;nope. so don't check any further
0455 0719 8A                    txa   
0456 071A 4A                    lsr   a
0457 071B 09 C0 00              ora   #$00C0
0458 071E EB                    xba                            ;A = $Cs00
0459 071F AA                    tax                            ;X = $Cs00
0460 0720
0461 0720                       longa off
0462 0720 E2 20                 sep   #$20
0463 0722
0464 0722 BF 01 00 00           lda   >1,x
0465 0726 C9 20                 cmp   #$20                     ;$Cs01 = $20?
0466 0728 D0 1A                 bne   @nextSlot                ;nope
0467 072A BF 03 00 00           lda   >3,x
0468 072E D0 14                 bne   @nextSlot                ;$Cs03 != $00
0469 0730 BF 05 00 00           lda   >5,x
0470 0734 C9 03                 cmp   #$03                     ;$Cs05 = $03?
0471 0736 D0 0C                 bne   @nextSlot
0472 0738 BF 07 00 00           lda   >7,x
0473 073C D0 06                 bne   @nextSlot                ;$Cs07 = $00
0474 073E BF FB 00 00           lda   >$FB,x                   ;get smartport ID byte
0475 0742 C9 C0                 cmp   #$C0                     ;have extended and additionals?
0476 0744              @nextSlot  
0477 0744                       longa on
0478 0744 C2 20                 rep   #$20
0479 0746 60                    rts   
0480 0747
0481 0747 8A           @notxSlot txa                           ;set NE 
0482 0748 60                    rts   
0483 0749
0484 0749 02 00        slotreg_bit DC W:$0002                  ;slot 1 slotreg ext bit
0485 074B 04 00                 DC W:$0004                     ;slot 2 slotreg ext bit
0486 074D 00 00                 DC W:$0000
0487 074F 10 00                 DC W:$0010                     ;slot 4 slotreg ext bit
0488 0751 20 00                 DC W:$0020                     ;slot 5 slotreg ext bit
0489 0753 40 00                 DC W:$0040                     ;slot 6 slotreg ext bit
0490 0755 80 00                 DC W:$0080                     ;slot 7 slotreg ext bit
0491 0757
0492 0757              **********************************************************************
0493 0757              * FillinDibStuff
0494 0757              *               Entry:
0495 0757              *                       m=1, x=1
0496 0757              *
0497 0757              *               Exit:
0498 0757              *                       m=1, x=1
0499 0757              *
0500 0757              **********************************************************************
0501 0757              Fillin_dib:  
0502 0757 AD 60 03              lda   last_slot
0503 075A A0 2E 00              ldy   #slot_num
0504 075D 97 20                 sta   [drvr_dib_ptr],y
0505 075F AD 62 03              lda   last_drive
0506 0762 A0 4A 00              ldy   #dib_hw_unit
0507 0765 97 20                 sta   [drvr_dib_ptr],y
0508 0767 A0 4C 00              ldy   #dib_acc_flag
0509 076A A9 00 00              lda   #00
0510 076D 97 20                 sta   [drvr_dib_ptr],y         ;clear the access flag
0511 076F AD E0 03     Fillin_Unit lda   dib_unit              ;16-bit fetch of 8-bit item!!!
0512 0772 29 7F 00              and   #$7F
0513 0775 A0 30 00              ldy   #unit_num
0514 0778 97 20                 sta   [drvr_dib_ptr],y
0515 077A 60                    rts   
0516 077B              **********************************************************************
0517 077B              * NextSlot:     calculates next slot number
0518 077B              *
0519 077B              *       creates slot scan in the following order:
0520 077B              *       5int,5ext,7ext,6ext,4ext,2ext,1ext
0521 077B              *
0522 077B              **********************************************************************
0523 077B              NextSlot:  
0524 077B AD 60 03              lda   last_slot
0525 077E 30 08                 bmi   @10
0526 0780 0A                    asl   a
0527 0781 AA                    tax   
0528 0782 BD 7F 07              lda   scanordermap-10,x
0529 0785 8D 60 03              sta   last_slot
0530 0788 60           @10      rts   
0531 0789
0532 0789 0D 00        scanordermap DC W:$D                    ;5 -> $D
0533 078B FF FF                 DC W:-1
0534 078D FF FF                 DC W:-1
0535 078F FF FF                 DC W:-1
0536 0791 FF FF                 DC W:-1                        ;$9 -> -1
0537 0793 09 00                 DC W:9                         ;$A -> $9
0538 0795 FF FF                 DC W:-1
0539 0797 0A 00                 DC W:$A                        ;$C -> $A
0540 0799 0F 00                 DC W:$F                        ;$D -> $F
0541 079B 0C 00                 DC W:$C                        ;$E -> $C
0542 079D 0E 00                 DC W:$E                        ;$F -> $E
0543 079F
0544 079F              *****************************************************************
0545 079F              *       Copy to bank1 the Direct Read routine for multi-blk read
0546 079F              *
0547 079F              *               Entry:  no regs defined
0548 079F              *
0549 079F              *               Exit:   no regs defined
0550 079F              *
0551 079F              *****************************************************************
0552 079F                       export copy_to_bank1
0553 079F              copy_to_bank1  
0554 079F                       longa on
0555 079F                       longi on
0556 079F AE 58 03              ldx   bank1_lgth
0557 07A2                       longa off
0558 07A2 E2 20                 SEP   #$20
0559 07A4 BD E2 17     @loop    lda   bank1_code,X
0560 07A7 9F 00 BC 01           sta   >bank1_org,X
0561 07AB CA                    dex   
0562 07AC 10 F6                 bpl   @loop
0563 07AE                       longa on
0564 07AE C2 20                 REP   #$20
0565 07B0 60                    rts   
0566 07B1
0567 07B1              *****************************************************************
0568 07B1              * Merge data from read into a contiguous block.
0569 07B1              *
0570 07B1              *               Entry:
0571 07B1              *                       m=1, x=1
0572 07B1              *                       c = 0 successful data read
0573 07B1              *                       c = 1 go retry read of data block
0574 07B1              *
0575 07B1              *               Exit:
0576 07B1              *                       m=1, x=1
0577 07B1              *                       X = low byte of number of data bytes read
0578 07B1              *                       Y = high byte of number of data bytes read
0579 07B1              *****************************************************************
0580 07B1                       export new_merge_it
0581 07B1                       longa off
0582 07B1                       longi off
0583 07B1              new_merge_it                            ;
0584 07B1 68                    pla                            ; get return address off stack
0585 07B2 68                    pla   
0586 07B3
0587 07B3 90 04                 bcc   data_read_ok             ; if error during read_data try again
0588 07B5 5C C7 59 FF           jmp   >try_more                ; otherwise give data to caller
0589 07B9
0590 07B9              data_read_ok                            ; 
0591 07B9 08                    php                            ; Native m=1, x=1 (from disk3.5 rom)
0592 07BA
0593 07BA                       longa off                      ;
0594 07BA                       longi on                       ;
0595 07BA E2 20                 sep   #$20                     ;
0596 07BC C2 10                 rep   #$10                     ;
0597 07BE
0598 07BE A2 01 00              ldx   #$0001                   ;
0599 07C1 A0 FF 01              ldy   #511                     ; assume non-mac 512 byte blk
0600 07C4 AD 51 0F              lda   |mac_flag                ; check for mac read or write
0601 07C7 F0 0D                 beq   mgit2                    ;
0602 07C9 A0 0B 02              ldy   #523                     ; If Mac call move 524 bytes
0603 07CC 80 08                 bra   mgit2                    ; 512 or 524 bytes not 513 or 525
0604 07CE              mgit1                                   ; 
0605 07CE BD 00 0E              lda   |buf3,x
0606 07D1 97 42                 sta   [<cmdbuffl],y
0607 07D3 88                    dey                            ; 255->256 xtion happens here
0608 07D4 30 11                 bmi   exit_merge               ;
0609 07D6              mgit2                                   ; 
0610 07D6 BD 00 0D              lda   |buf2,x
0611 07D9 97 42                 sta   [<cmdbuffl],y
0612 07DB 88                    dey                            ; 511->512 transition occurs here
0613 07DC 30 09                 bmi   exit_merge               ;
0614 07DE              mgit3                                   ; 
0615 07DE BD 00 0C              lda   |buf1,x
0616 07E1 97 42                 sta   [<cmdbuffl],y
0617 07E3 E8                    inx                            ; point to next possible byte
0618 07E4 88                    dey                            ; move destination index
0619 07E5 10 E7                 bpl   mgit1                    ;
0620 07E7              exit_merge                              ; 
0621 07E7 E8                    inx                            ; form accurate byte count
0622 07E8
0623 07E8                       longa on                       ; m=0, x=0
0624 07E8                       longi on                       ;
0625 07E8 C2 30                 rep   #$30                     ;
0626 07EA
0627 07EA 8A                    txa                            ; byte count
0628 07EB 28                    plp                            ; restore processor state
0629 07EC
0630 07EC                       longa off                      ;
0631 07EC                       longi off                      ;
0632 07EC
0633 07EC AA                    tax                            ; x = low byte of byte count
0634 07ED EB                    xba                            ;
0635 07EE A8                    tay                            ; y = high byte of byte count
0636 07EF 5C 1C 5A FF           jmp   >sbset                   ; all done here go back to the rom
0637 07F3                       eject 
0638 07F3              *****************************************************************
0639 07F3              *
0640 07F3              *               This module will install return addresses
0641 07F3              *               on the stack which will allow us to call routines
0642 07F3              *               in the bank $FF rom for the Disk 3.5 driver and
0643 07F3              *               return back to us when done.
0644 07F3              *
0645 07F3              *               The routine pushes a 24 bit return address to the
0646 07F3              *               new Merge_it, pushes a 16 bit address to a rtl
0647 07F3              *               instruction in bank $FF.
0648 07F3              *               When a call is made to the ReadData routine in the
0649 07F3              *               3.5" disk driver control will be passed here. This
0650 07F3              *               routine pushes the 24 bit address of the new_merge_it
0651 07F3              *               code, pushes the return address to a RTL instruction
0652 07F3              *               in bank $FF and then jumps to the read_data routine
0653 07F3              *               in the rom.
0654 07F3              *                       When the read_data routine completes, it does
0655 07F3              *               an RTS to the RTL instruction which will return to the
0656 07F3              *               new merge_it code.  Merge it in turn will pass control
0657 07F3              *               back to the rom when it completes.
0658 07F3              *
0659 07F3              *               Entry:
0660 07F3              *                       m=1, x=1
0661 07F3              *                       Data bank = $E1
0662 07F3              *
0663 07F3              *
0664 07F3              *               Exit:
0665 07F3              *                       m=1, x=1
0666 07F3              *                       Data bank = $E1
0667 07F3              *                       A = trashed
0668 07F3              *
0669 07F3              *                       Stack layout
0670 07F3              *                       +-----------+ --------
0671 07F3              *                       |   Bank    |
0672 07F3              *                       +-----------+
0673 07F3              *                       |   High    |   Address of new_merge_it
0674 07F3              *                       +-----------+
0675 07F3              *                       |    Low    |
0676 07F3              *                       +-----------+ --------
0677 07F3              *                       |   High    |
0678 07F3              *                       +-----------+   Address to RTL inst. in bank $FF
0679 07F3              *                       |    Low    |
0680 07F3              *                       +-----------+ --------
0681 07F3              *               SP >--> |    ???    |
0682 07F3              *                       +-----------+
0683 07F3              *
0684 07F3              *****************************************************************
0685 07F3                       export merge_patch
0686 07F3              merge_patch                             ;
0687 07F3                       longa off
0688 07F3                       longi off
0689 07F3
0690 07F3 68                    pla                            ; remove old 'RTL' - 1/9/89 RBM
0691 07F4 68                    pla   
0692 07F5 68                    pla   
0693 07F6
0694 07F6 4B                    phk                            ; push long return address
0695 07F7 F4 B0 07              pea   new_merge_it-1           ; of new merge_it routine
0696 07FA F4 9B C5              pea   rtl_addr-1               ; push return addr to rtl
0697 07FD 5C 44 62 FF           jmp   >read_data               ; call the rom read data routine
0698 0801
0699 0801                       eject 
0700 0801              *****************************************************************
0701 0801              *
0702 0801              *               This module will modify the read_data hook for
0703 0801              *               the AppleDisk 3.5 driver to point to a ram based
0704 0801              *               patch which contains a modified Merge it routine.
0705 0801              *
0706 0801              * Entry: via a 'JSR'
0707 0801              *               A Reg = Undefined
0708 0801              *               X Reg = Undefined
0709 0801              *               Y Reg = Undefined
0710 0801              *             Dir Reg = $0000
0711 0801              *               B Reg = Undefined
0712 0801              *               P Reg = N V M X D I Z C  E
0713 0801              *                       x x 0 0 0 0 x x  0
0714 0801              *
0715 0801              * EXIT: via an 'RTS'
0716 0801              *               A Reg = Unchanged
0717 0801              *               X Reg = Unchanged
0718 0801              *               Y Reg = Unchanged
0719 0801              *             Dir Reg = Unchanged
0720 0801              *               B Reg = Unchanged
0721 0801              *               P Reg = N V M X D I Z C  E
0722 0801              *                       x x 0 0 0 0 x x  0
0723 0801              *
0724 0801              *
0725 0801              *****************************************************************
0726 0801                       export set_hook
0727 0801              set_hook                                ;
0728 0801                       longa on
0729 0801                       longi on
0730 0801
0731 0801              *
0732 0801              * Set unit number for hook installation.
0733 0801              *
0734 0801 18                    clc   
0735 0802 2C 68 03              bit   ext_slot
0736 0805 30 4C                 bmi   @doNothing               ;
0737 0807
0738 0807 E2 20                 sep   #$20                     ; 8 bit 'm'
0739 0809                       longa off
0740 0809
0741 0809 A0 30 00              ldy   #unit_num
0742 080C B7 20                 lda   [<drvr_dib_ptr],y
0743 080E 8D 86 04              sta   |sethook_unit
0744 0811 A9 02                 lda   #$02                     ; hook refernece is for read data
0745 0813 8D 8E 04              sta   |hook_ref
0746 0816
0747 0816 C2 20                 rep   #$20                     ; 16 bit 'm'
0748 0818                       longa on
0749 0818              *
0750 0818              * Install the merge patch so that the drive can operate at 2:1 interleave.
0751 0818              * This patch is only installed on old roms.
0752 0818              *
0753 0818 AD 66 03              lda   |rom_version             ; should merge patch be installed?
0754 081B C9 02 00              cmp   #$0002
0755 081E B0 15                 bge   @no_merge
0756 0820 A9 F3 07              lda   #merge_patch             ;point to the new merge it code
0757 0823 8D 8F 04              sta   |hook_addr
0758 0826 A9 07 02              lda   #merge_patch>>8
0759 0829 8D 90 04              sta   |hook_addr+1
0760 082C A5 00                 lda   <drvr_dev_num            ; device number to read
0761 082E A2 80 04              ldx   #sethook_list
0762 0831 22 80 FC 01           jsl   to_b0_core
0763 0835              *
0764 0835              * Install the patch to detect direct firmware access.
0765 0835              *
0766 0835              @no_merge  
0767 0835 E2 20                 sep   #$20                     ; 8 bit 'm'
0768 0837                       longa off
0769 0837
0770 0837 A9 08                 lda   #$08                     ; hook reference number is for main vector
0771 0839 8D 8E 04              sta   |hook_ref
0772 083C
0773 083C C2 20                 rep   #$20                     ; 16 bit 'm'
0774 083E                       longa on
0775 083E
0776 083E A9 97 08              lda   #access_detect           ;point at external access detection
0777 0841 8D 8F 04              sta   |hook_addr
0778 0844 A9 08 02              lda   #access_detect>>8
0779 0847 8D 90 04              sta   |hook_addr+1
0780 084A A5 00                 lda   <drvr_dev_num            ; device number to read
0781 084C A2 80 04              ldx   #sethook_list
0782 084F 22 80 FC 01           jsl   to_b0_core
0783 0853 60           @doNothing rts   
0784 0854
0785 0854              **********************************************************************
0786 0854              *
0787 0854              *       Download code for the access detector in UCIC card "ROM"
0788 0854              *
0789 0854              **********************************************************************
0790 0854                       export set_extaccess
0791 0854                       longa on
0792 0854                       longi on
0793 0854 18           set_extaccess clc   
0794 0855 2C 68 03              bit   ext_slot
0795 0858 10 34                 bpl   @exit
0796 085A
0797 085A A0 30 00              ldy   #unit_num
0798 085D B7 20                 lda   [drvr_dib_ptr],y         ;get SmartPort Unit #
0799 085F
0800 085F E2 20                 sep   #$20                     ; 8 bit 'm'
0801 0861                       longa off
0802 0861 8D A8 04              sta   setAdrs_unit
0803 0864 8D B8 04              sta   dnLoad_unit
0804 0867 C2 20                 rep   #$20                     ; 16 bit 'm'
0805 0869                       longa on
0806 0869
0807 0869 0A                    asl   a
0808 086A AA                    tax   
0809 086B BD 8D 08              lda   dwnldAdrs-2,x
0810 086E 8D B0 04              sta   setAdrs_addr             ;fill in the adrs for this unit
0811 0871
0812 0871 A5 00                 lda   <drvr_dev_num            ; device number to read
0813 0873 A2 A2 04              ldx   #setAdrs_list
0814 0876 22 80 FC 01           jsl   to_b0_core
0815 087A B0 12                 bcs   @exit
0816 087C              *
0817 087C              * now fill in the address of this dib's access flag for the detector routine
0818 087C A5 20                 lda   <drvr_dib_ptr            ;get low word of dib adrs
0819 087E 18                    clc   
0820 087F 69 4C 00              adc   #dib_acc_flag
0821 0882 8D C3 04              sta   dibXflag_adrs+1          ;+1 to skip the opcode
0822 0885              * the bank adrs should have been relocated properly when I was loaded
0823 0885
0824 0885 A5 00                 lda   <drvr_dev_num            ; device number to read
0825 0887 A2 B2 04              ldx   #dnLoad_list
0826 088A 22 80 FC 01           jsl   to_b0_core               ;download the 7 bytes to the card's "ROM"
0827 088E
0828 088E 60           @exit    rts   
0829 088F
0830 088F                       entry dwnldAdrs
0831 088F 80 0B        dwnldAdrs DC W:$0B80
0832 0891 A0 0B                 DC W:$0BA0
0833 0893 C0 0B                 DC W:$0BC0
0834 0895 E0 0B                 DC W:$0BE0
0835 0897
0836 0897              *****************************************************************
0837 0897              * ACCESS_DETECT
0838 0897              *
0839 0897              * ENTRY: Call via 'JSL'
0840 0897              *               A Reg = Undefined
0841 0897              *               X Reg = Undefined
0842 0897              *               Y Reg = Undefined
0843 0897              *             Dir Reg = $0000
0844 0897              *               B Reg = Undefined
0845 0897              *               P Reg = x x 1 1 0 0 x x  0
0846 0897              * EXIT: via an 'RTL'
0847 0897              *               A Reg = Unchanged
0848 0897              *               X Reg = Unchanged
0849 0897              *               Y Reg = Unchanged
0850 0897              *             Dir Reg = Unchanged
0851 0897              *               B Reg = Unchanged
0852 0897              *               P Reg = x x 1 1 0 0 x x  0
0853 0897              *
0854 0897              *  Called from IIgs SmartPort dispatcher firmware 
0855 0897              *  in 8 bit native mode
0856 0897              *****************************************************************
0857 0897                       export access_detect
0858 0897                       longa off
0859 0897                       longi off
0860 0897 08           access_detect php                       ;save status before changing it
0861 0898 48                    pha   
0862 0899 AF 5A 00 00           lda   >cmdid                   ; get internal firmware unit #
0863 089D CF 20 0F E1           cmp   >id1                     ; is it the same as drive #1?
0864 08A1 D0 08                 bne   @10
0865 08A3 A9 FF                 lda   #$FF
0866 08A5 8F AC 00 02           sta   >dib1acc_flag            ;set dib1 access flag
0867 08A9 80 0C                 bra   @20                      ;all done
0868 08AB CF 21 0F E1  @10      cmp   >id2
0869 08AF D0 06                 bne   @20
0870 08B1 A9 FF                 lda   #$FF
0871 08B3 8F 06 01 02           sta   >dib2acc_flag            ;set dib2 access flag
0872 08B7 68           @20      pla                            ;restore 8bit A
0873 08B8 28                    plp                            ;restore status
0874 08B9 6B                    rtl   
0875 08BA
0876 08BA                       endp 
